Ext.data.JsonP.sol_ClassManager({"tagname":"class","name":"sol.ClassManager","autodetected":{},"files":[{"filename":"lib_Class.js","href":"lib_Class.html#sol-ClassManager"}],"singleton":true,"author":[{"tagname":"author","name":"Nils Mosbach, ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloall":true,"members":[{"name":"definedClasses","tagname":"property","owner":"sol.ClassManager","id":"property-definedClasses","meta":{"private":true}},{"name":"dependencies","tagname":"property","owner":"sol.ClassManager","id":"property-dependencies","meta":{"private":true}},{"name":"version","tagname":"property","owner":"sol.ClassManager","id":"property-version","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.ClassManager","id":"method-S-super","meta":{"private":true}},{"name":"addWatcherClass","tagname":"method","owner":"sol.ClassManager","id":"method-addWatcherClass","meta":{"private":true}},{"name":"create","tagname":"method","owner":"sol.ClassManager","id":"method-create","meta":{}},{"name":"define","tagname":"method","owner":"sol.ClassManager","id":"method-define","meta":{}},{"name":"definePrototype","tagname":"method","owner":"sol.ClassManager","id":"method-definePrototype","meta":{"private":true}},{"name":"extend","tagname":"method","owner":"sol.ClassManager","id":"method-extend","meta":{"private":true}},{"name":"extendMixin","tagname":"method","owner":"sol.ClassManager","id":"method-extendMixin","meta":{"private":true}},{"name":"getClass","tagname":"method","owner":"sol.ClassManager","id":"method-getClass","meta":{"private":true}},{"name":"getMissingDependencies","tagname":"method","owner":"sol.ClassManager","id":"method-getMissingDependencies","meta":{}},{"name":"handleWatcher","tagname":"method","owner":"sol.ClassManager","id":"method-handleWatcher","meta":{"private":true}},{"name":"mixin","tagname":"method","owner":"sol.ClassManager","id":"method-mixin","meta":{"private":true}}],"alternateClassNames":[],"aliases":{},"id":"class-sol.ClassManager","short_doc":"Manager instance that handles the definition and creation of classes. ...","classIcon":"icon-singleton","superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/lib_Class.html#sol-ClassManager' target='_blank'>lib_Class.js</a></div></pre><div class='doc-contents'><p>Manager instance that handles the definition and creation of classes.</p>\n\n<p>Class definitions are handled internally by the ClassManager.\nTherefore the creation of classes should always be done by calling <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<h1>Defining classes - basic syntax</h1>\n\n<p>Every class is represented by a class name that should include a namespace and the class definition.\nThe class definition is a js object that represents the contents of that class. Functions and properties\nthat are part of the classDefinition will be part of the class prototype.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(className, classDefinition);\n</code></pre>\n\n<p>Every class has its own constructor which is specified by a function called initialize.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Fighter\", {\n  name: '',\n  power: 0,\n\n  initialize: function (config) {\n    var me = this;\n\n    me.name = config.name;\n    me.power = config.power;\n  },\n\n  highFive: function () {\n    log.info(\"high five\");\n    return \"^5\";\n  }\n});\n</code></pre>\n\n<h1>Inheritance</h1>\n\n<p>Classes can inherit properties and functions from a super class.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(className, {\n  extend: superClassName\n});\n</code></pre>\n\n<p>Following example will inherit name and power-properties as well as the highFive-function of the fighter.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Saiyajin\", {\n  extend: \"sol.test.Fighter\",\n\n  level: 1,\n\n  initialize: function (config) {\n    var me = this;\n    me.$super(\"sol.test.Fighter\", \"initialize\", [config]);\n    me.level = 1;\n  },\n\n  transform: function() {\n    var me = this;\n    if(me.level &lt; 3) {\n      me.level++;\n      me.power *= 50;\n    }\n  }\n});\n</code></pre>\n\n<p>Superclass functions can be overridden. With the help of the $super-function, functions of the superclass can be called.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n\n<h1>Mixins</h1>\n\n<p>Mixins allow inheriting properties and functions from multiple classes. This concept is also called multiple class inheritance.\nThis can be useful if operation might get used by several classes that implement different use cases. Therefore an Array of classes\nshould be passed to the class definition.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(className, {\n  mixins: [mixinClassName]\n});\n</code></pre>\n\n<p>If mixins are overritten by the implementing class, there is no way of calling the original mixin function. $super only applies to\nfunctions that have been inherited from the superclass.</p>\n\n<p>Mixins must be defined by <code>mixin: true</code> which also prevents mixin classes from general <a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a> inheritance.</p>\n\n<p>Lets define a mixin 'weep' for the fighters.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.mixins.Weep\", {\n  mixin: true,\n\n  weep: function () {\n    log.debug(\"All fighters do it sometimes\");\n  }\n});\n\n<a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Fighter\", {\n  mixins: ['sol.test.mixins.Weep'],\n  name: '',\n  power: 0,\n\n  initialize: function (config) {\n    var me = this;\n\n    me.name = config.name;\n    me.power = config.power;\n  },\n\n  highFive: function () {\n    log.info(\"high five\");\n    return \"^5\";\n  }\n});\n</code></pre>\n\n<p>Mixins also support initialization operations. Please note that this should not be external system calls.\nInitialization of mixins is executed after all classes and superclasses have been initialized.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.mixins.Weep\", {\n  mixin: true,\n\n  initialize: function(config) {\n    var me = this;\n    me.wheepName = config.name;\n  }\n\n  weep: function () {\n    log.debug(\"All fighters do it sometimes, even \"+ me.wheepName);\n  }\n});\n</code></pre>\n\n<h1>Defining singleton classes</h1>\n\n<p>Singletons can be created by passing a singleton parameter to the class definition.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(className, {\n  singleton: true\n});\n</code></pre>\n\n<p>In this case a class is created in the given namespace after the class was defined.\nLets define an arena for the fighters.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Arena\", {\n  singleton: true,\n\n  ambience: \"dark\",\n\n  changeAmbience: function(ambience) {\n    var me = this;\n    me.ambience = ambience;\n  },\n\n  fight: function (fighter1, fighter2) {\n    return (fighter1.power &gt; fighter2.power) ? fighter1.name : fighter2.name);\n  }\n});\n\nsol.test.Arena.changeAmbience(\"dark and scary\");\n</code></pre>\n\n<h1>Creating class instances</h1>\n\n<p>Instances of defined classes can be created by <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(). An options object can be used\nin order to pass config properties to the initialize function.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(className, options);\n</code></pre>\n\n<p>Lets create a new Saiyajin fighter.\nThe name and power configurations are handled by the initialize function of the fighter.</p>\n\n<pre><code>var goku = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Saiyajin\", {\n  name: \"Son-Goku\",\n  power: 3000000\n});\n</code></pre>\n\n<h1>Example using classes</h1>\n\n<p>Following example shows a basic usage of the classes defined by previous examples.</p>\n\n<pre><code>var goku, freezer, winner;\n\ngoku = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Saiyajin\", {\n  name: \"Son-Goku\",\n  power: 3000000\n});\n\nfreezer = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {\n  name: \"Freezer\",\n  power: 120000000\n});\n\nvar winner = sol.test.Arena.fight(goku, freezer);\nlog.info(\"[MATCH] winner 1st=\" + winner);\n\ngoku.transform();\n\nwinner = sol.test.Arena.fight(goku, freezer);\nlog.info(\"[MATCH] winner 2nd=\" + winner);\nfreezer.weep();\n</code></pre>\n\n<h1>Class properties and prototyping</h1>\n\n<p><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a> allows defining static values on class prototypes. This should be avoided and only be used if the core concept of js prototypes is clear.</p>\n\n<p><b>Using class properties for global definitions/ constants</b></p>\n\n<p>Basically prototyping allows defining static property values that can be used by all instances. That might be useful for constants or global definitions.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Fighter\", {\n  allowedAmountOfFights: 10,\n  modes: {\n    slow: function() {},\n    fast: function() {}\n  }\n});\n</code></pre>\n\n<p><b>Misuse and class properties</b></p>\n\n<p>If working with properties defined by the class prototype they are static values.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Fighter\", {\n  fightsTotal: 0,\n  fights: [],\n  fight: function() { this.fightsTotal++; }\n});\n\nvar fighter1 = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {});\nfighter1.fight();                // fightsTotal = 1\nfighter1.fights.push('first');   // fights = ['first']\nfighter1.fight();                // fightsTotal = 2\nfighter1.fights.push('second');   // fights = ['first', 'second']\nvar fighter2 = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {});\nfighter2.fight();                // fightsTotal = 3\nfighter1.fights.push('third');   // fights = ['first', 'second', 'third']\n</code></pre>\n\n<p>However if properties are applied on the instance itself they are primarily used. For example:</p>\n\n<pre><code>var fighter1 = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {});\nfighter1.fight();                // fightsTotal = 1\nfighter1.fight();                // fightsTotal = 2\nvar fighter2 = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {});\n// set a new property instance on the fighter2 instance\nfighter2.fightsTotal = 0;\nfighter2.fight();                // fightsTotal = 1\nfighter1.fight();                // fightsTotal = 3\n</code></pre>\n\n<p>In order to solve this problem, never work (extend, modify or calculate) with values instances applied on class prototype level.\nIf working with values they <em>must</em> be defined in the initialize function!</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.test.Fighter\", {\n  requiredConfig: ['name'],\n  allowedAmountOfFights: 10,\n\n  initialize: function(config) {\n    var me = this;\n    me.fights = [];\n  }\n\n  fight: function() {\n    var me = this;\n    if (me.fights.length &lt; me.allowedAmountOfFights) {\n      me.fights.push(new Date());\n    }\n  }\n});\n</code></pre>\n\n<p>When using config properties passed to <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a> they will get added to the instance by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.test.Fighter\", {\n  name: 'Son Goku\"\n});\n</code></pre>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-definedClasses' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-property-definedClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-property-definedClasses' class='name expandable'>definedClasses</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>defined classes by <a href=\"#!/api/sol.ClassManager-method-define\" rel=\"sol.ClassManager-method-define\" class=\"docClass\">sol.ClassManager.define() or sol.define()</a></p>\n</div><div class='long'><p>defined classes by <a href=\"#!/api/sol.ClassManager-method-define\" rel=\"sol.ClassManager-method-define\" class=\"docClass\">sol.ClassManager.define() or sol.define()</a></p>\n</div></div></div><div id='property-dependencies' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-property-dependencies' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-property-dependencies' class='name expandable'>dependencies</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>keeps a list of dependencies that are used by watchers.</p>\n</div><div class='long'><p>keeps a list of dependencies that are used by watchers.</p>\n</div></div></div><div id='property-version' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-property-version' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-property-version' class='name expandable'>version</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>1</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, scope, method, args</span> ) : *<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Helper function to address function of a classes superclass if the function was overridden. ...</div><div class='long'><p>Helper function to address function of a classes superclass if the function was overridden.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : Object<div class='sub-desc'><p>prorotype of the superclass.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>instance of the class.</p>\n</div></li><li><span class='pre'>method</span> : String<div class='sub-desc'><p>name of the method that should be called.</p>\n</div></li><li><span class='pre'>args</span> : Arguments<div class='sub-desc'><p>arguments as an array that should be passed to the superclass' function.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>*</span><div class='sub-desc'><p>result of the function call.</p>\n</div></li></ul></div></div></div><div id='method-addWatcherClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-addWatcherClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-addWatcherClass' class='name expandable'>addWatcherClass</a>( <span class='pre'>className, classDefinition, dependencies</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds a class that is requesting missing dependencies. ...</div><div class='long'><p>Adds a class that is requesting missing dependencies.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class</p>\n</div></li><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>definition of the class</p>\n</div></li><li><span class='pre'>dependencies</span> : Array<div class='sub-desc'><p>List of classes that are missing</p>\n</div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-create' class='name expandable'>create</a>( <span class='pre'>className, config</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new instance of a previously defined class. ...</div><div class='long'><p>Creates a new instance of a previously defined class.\nNew classes should always be created using <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<pre><code>var log = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('sol.common.Logger', {\n  scope: 'sol.test'\n});\n</code></pre>\n\n<p>If no config object is passed an empty object will be used.</p>\n\n<p>Please refer to <a href=\"#!/api/sol.ClassManager\" rel=\"sol.ClassManager\" class=\"docClass\">sol.ClassManager</a> for more information on how classes can be created.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>configuration for the initialization function.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>created class instance.</p>\n</div></li></ul></div></div></div><div id='method-define' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-define' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-define' class='name expandable'>define</a>( <span class='pre'>className, classDefinition</span> ) : null<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines a new class. ...</div><div class='long'><p>Defines a new class.\nNew classes should always be defined using <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>('sol.common.Logger', {\n  extend: 'sol.common.BaseClass',\n  mixins: ['sol.mixins.Configuration'],\n  singleton: false,\n\n    scope: 'sol',\n\n  initialize: function(config) {\n    var me = this;\n    me.scope = config.scope || me.scope;\n  },\n\n  debug: function (txt) {\n    var me = this;\n    console.log(me.scope + 'debug from logger class: '+ txt);\n  }\n});\n</code></pre>\n\n<p>Please refer to <a href=\"#!/api/sol.ClassManager\" rel=\"sol.ClassManager\" class=\"docClass\">sol.ClassManager</a> for more information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace.</p>\n</div></li><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>class definition.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>null</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-definePrototype' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-definePrototype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-definePrototype' class='name expandable'>definePrototype</a>( <span class='pre'>className, classDefinition</span> ) : Function<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates and registers a new class prototype. ...</div><div class='long'><p>Creates and registers a new class prototype.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace</p>\n</div></li><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>definition if the new class as a js object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Function</span><div class='sub-desc'><p>new class prototype</p>\n</div></li></ul></div></div></div><div id='method-extend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-extend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-extend' class='name expandable'>extend</a>( <span class='pre'>$class, superClass</span> ) : object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Extends a class based on properties and functions given its superclass. ...</div><div class='long'><p>Extends a class based on properties and functions given its superclass.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>$class</span> : Object<div class='sub-desc'><p>class that inherits properties and functions from the superclass.</p>\n</div></li><li><span class='pre'>superClass</span> : Object<div class='sub-desc'><p>super class</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>object</span><div class='sub-desc'><p>new class with inherited properties and functions.</p>\n</div></li></ul></div></div></div><div id='method-extendMixin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-extendMixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-extendMixin' class='name expandable'>extendMixin</a>( <span class='pre'>$class, mixinClass, className, mixinName</span> ) : object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Extends a class based on properties and functions given its superclass. ...</div><div class='long'><p>Extends a class based on properties and functions given its superclass.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>$class</span> : Object<div class='sub-desc'><p>class that inherits properties and functions from the superclass.</p>\n</div></li><li><span class='pre'>mixinClass</span> : Object<div class='sub-desc'><p>super class</p>\n</div></li><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the current class (used by error handling)</p>\n</div></li><li><span class='pre'>mixinName</span> : String<div class='sub-desc'><p>name of the current mixin class (used by error handling)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>object</span><div class='sub-desc'><p>new class with inherited properties and functions.</p>\n</div></li></ul></div></div></div><div id='method-getClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-getClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-getClass' class='name expandable'>getClass</a>( <span class='pre'>className</span> ) : *<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the registered prototype of a class thanks to its name. ...</div><div class='long'><p>Returns the registered prototype of a class thanks to its name.\nIf no class was registered undefined is returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>*</span><div class='sub-desc'><p>class prototype</p>\n</div></li></ul></div></div></div><div id='method-getMissingDependencies' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-getMissingDependencies' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-getMissingDependencies' class='name expandable'>getMissingDependencies</a>( <span class='pre'>classDefinition</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>reads the list of missing dependencies for a given classDefinition ...</div><div class='long'><p>reads the list of missing dependencies for a given classDefinition</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>definition of the class</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>List of all missing dependencies</p>\n</div></li></ul></div></div></div><div id='method-handleWatcher' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-handleWatcher' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-handleWatcher' class='name expandable'>handleWatcher</a>( <span class='pre'>className</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Analyses dependencies for a class by a given name. ...</div><div class='long'><p>Analyses dependencies for a class by a given name. Applies class definitions when dependencies are loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class that was definied.</p>\n</div></li></ul></div></div></div><div id='method-mixin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.ClassManager'>sol.ClassManager</span><br/><a href='source/lib_Class.html#sol-ClassManager-method-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.ClassManager-method-mixin' class='name expandable'>mixin</a>( <span class='pre'>$class, classDefinition, className</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Applies mixins given by a class definition to the classes prototype definition. ...</div><div class='long'><p>Applies mixins given by a class definition to the classes prototype definition.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>$class</span> : Object<div class='sub-desc'><p>class that mixins should be applied to.</p>\n</div></li><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>configuration of the class that contains list of possible mixins.</p>\n</div></li><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class (used by error handling)</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});